#ifndef GLOB_PROM_H
#define GLOB_PROM_H

#include "struktury.h"                                                          //komplexnější proměnné a objekty

constexpr real πp = 1.5707963267948966192313216916397514420985846996875L;
constexpr real π  = 3.1415926535897932384626433832795028841971693993751L;
constexpr real π2 = 6.2831853071795864769252867665590057683943387987502L;
constexpr real oo = 1000;                                                       //nekonečno
constexpr real ε = 5E-08;
constexpr real jl2ε = 1E+07;                                                    //(ε+ε)^-1

extern tensor_2 t;                                                              //kovariantní a kontravariantní tenzor metriky v kódu pro virtuální procesor
extern black_hole_param P;                                                      //parametry metriky (díry)
extern f_vec poc_sour_poz;                                                      //počáteční podmínky
extern MyImage image[2400];                                                     //pole snímků (vypadá že to zabere spoustu místa, ale snímky zatím mají jen jeden bod)
extern Counter num_thread;                                                      //počítadlo použitých vláken
extern QImage b_gnd,acr;                                                        //obrázek pozadí a akrečního disku
extern real precise;
extern real h1;                                                                 //horizont 1
extern real h2;                                                                 //horizont 2
extern real o_spd[512];                                                         //pole předvypočtených kruhových rychlostí v místě keplerova disku
extern real φ_spd[64];                                                          //pole předvypočtených kvantizovaných úhlových rychlostí v místě keplerova disku
extern int frame;                                                               //konkrétní zobrazený snímek
extern int transp;                                                              //míra průhlednosti keplera
extern bool stop, mink;                                                         //generální stop všech výpočtů
extern bool el_ab;                                                              //příznak eliminace posunu aberací
extern bool shift;                                                              //příznak rudého posuvu
extern bool kepler;                                                             //existence akrečního disku
extern bool beam;                                                               //příznak výpočtu beaminngu
extern bool simul;                                                              //typ zobrazení rudého posuvu
extern bool sour;                                                               //zobrazí souřadnice v obraze

void inicialize();

#endif // GLOB_PROM_H
