#include "QtCore/qrunnable.h"
#include "QtGui/qpainter.h"
#include "formulas.h"
#include "glob_prom.h"
#include "ui_mainwindow.h"                                                      //grafické rozhraní

void ImgFree(void* buf);                                                        //čistící funkce pro QImage

template <typename T>
T addTxtImg(T inImage, MyImage &image) {                                        //přidání koordinát do obrázku
    if (sour) {
        QFont font;
        font.setPointSize(10);
        QPainter painter(&inImage);
        painter.setFont(font);
        painter.setPen(QColor(0, 0, 0, 0));
        painter.setBrush(QColor(0, 0, 0, 128));
        painter.drawRect(5, 11, 88, 20);
        painter.setPen(Qt::white);
        real v = t_tet(image.v(), image.x())[0];
        v = sqrt(1 - 1 / v / v);
        painter.drawText(5 , 20, "r:" + QString::number(image.x()[1], 'f', 2));
        painter.drawText(50, 20, "θ:" + QString::number(180 * image.x()[2] / π,
                                         'f', 1).rightJustified(5, '0') + "°");
        painter.drawText(5 , 30, "t:" + QString::number(image.x()[0], 'f', 2).
                                                  leftJustified(7, ' ', true));
        painter.drawText(60, 30, "v:" + QString::number(v, 'f', 2));
    }
    return inImage;
}
QImage raw_to_image(MyImage &image, int width, int height, int w=0, int h=0);   //převod MyImage na QImage (přetížení)
void waitToFreeThread(int numUsedThread);                                       //čekání na uvolnění jednoho z vláken pro další výpočet
qint64 Compute(f_vec x_, f_vec v_, int w_, int h_, real _, Ui::MainWindow *ui);

class SetColor : public QRunnable
{
public:
    SetColor(int &x, int &y, int &w, int &h, real &z, f_vec &sp, f_vec &rp);
    void run() override;

private:
    int x, y, w, h;
    real z;
    f_vec sp, rp;
};
